#ifndef DFFEXP_H
#define DFFEXP_H

#include "rwcommon.h"
#include "material.h"
#include "remapper.h"
#include "warnings.h"
#include "RwExpError.h"

#define _RW_EPSILON ((float)0.001)

// a matrix with a determinant between +/- this is defined as singular.
const float c_SingularMatrixDeterminant = _RW_EPSILON; 

class CDffDlg;

#include "characterstudio.h"

class DFFExport : public SceneExport
/*
code cleanup goal: this class should be used to represent the interface back to MAX
and the user interface ONLY.
*/
{
public:
                    DFFExport();                        /* Constructor */
                    ~DFFExport();                       /* Destructor */
    int             ExtCount();                         /* Number of extensions supported */
    const TCHAR *   Ext(int n);                         /* Extension #n (i.e. "3DS") */
    const TCHAR *   LongDesc();                         /* Long ASCII description (i.e. "Autodesk 3D Studio File") */
    const TCHAR *   ShortDesc();                        /* Short ASCII description (i.e. "3D Studio") */
    const TCHAR *   AuthorName();                       /* ASCII Author name */
    const TCHAR *   CopyrightMessage();                 /* ASCII Copyright message */
    const TCHAR *   OtherMessage1();                    /* Other message #1 */
    const TCHAR *   OtherMessage2();                    /* Other message #2 */
    unsigned int    Version();                          /* Version number * 100 (i.e. v3.01 = 301) */
    void            ShowAbout(HWND hWnd);               /* Show DLL's "About..." box */
    int             DoExport(const TCHAR *name, 
                             ExpInterface *ei,Interface *i, BOOL suppressPrompts, DWORD options); /* Export file */

private:
    float           m_nScaleFactor;
    TimeValue       m_tvStart;
    TimeValue       m_tvEnd;
    int             m_nNumFrames;    
    ReMapper        m_remapper;    

    /* Export settings */
    BOOL            m_anim;
    BOOL            m_morphTargets;
    BOOL            m_seqAnim;    
    BOOL            m_preLightClump;
    BOOL            m_ignoreSmoothing;
    BOOL            m_retainObjInWorldSpace;
    BOOL            m_linkBySelSets;   
    BOOL            m_triStripMesh;
    BOOL            m_limitUVs;
    BOOL            m_colorVertexPrelight;
    BOOL            m_filterTopLevelCSKeys;
    int             m_limitUVMax;
    int             m_nScaleType;        
    int             m_nAnimFrameInterval;
    float           m_weldThreshold;
    float           m_weldThresholdUV;
    BOOL            m_backfaceNormals;
    BOOL            m_2SidedMaterials;
    BOOL            m_CSExport;
    BOOL            m_exportNormals;
    BOOL            m_exportLit;
    BOOL            m_weldVertices;
    char *          m_defaultAnimName;
    BOOL            m_skinning;
    Matrix3         m_objectOffset;
    Matrix3         m_scaleMatrix;
    Point3          m_nodeScaleFactor;
    BOOL            m_noExtraInterpKeys;
    BOOL            m_texturenameCase;
    BOOL            m_exportLabels;
    BOOL            m_maxNativeSkin;
    BOOL            m_generateReportFile;
    BOOL            m_displayReport;
    BOOL            m_legacyOptions;
    BOOL            m_skinSKA;
    BOOL            m_exportHAnim;
    BOOL            m_HAnimLocalSpaceMatrices;
    BOOL            m_HAnimNoMatrices;
    BOOL            m_HAnimSubHierarchyAnim;

    /* exporter data */
    INode           *m_topOfSelectedHierarchy;
    INode           *m_selectedNodeInSelectedHierarchy;
    INode*          rootNode;
    RwInt32 *       vertexBoneMap;
    RpAtomic *      CSSkinAtomic;
    INode **        CSBoneIndexNodePointers;
    RwInt32 *       CSBoneIndexTags;
    RwInt32         CSExtraBoneTagIndex;
    int             CSNumBones;
    char *          CSBipedName;
    RwUInt32        lastChildIndex;
    WarningList     m_WarningsList;
    
    /* RpSkin animation and skeleton building */
    AnimKeyFrameListEntry SKAKeyFrameList;
    AnimKeyFrameListEntry AnimKeyFrameList;
    RwMatrixWeights *skinMatrixWeights;
    RwUInt32 *      skinVertexIndices;
    RwMatrix *      skinInverseMatrices;
    RwUInt32 *      skinFlags;

    /* Export functions */

    //top level scene export ... TraverseScene.cpp
    //if export was succesful, error message returned empty.
    //if export had to be halted for some reason of user incompetence,
    //a non-empty explanation should be returned.
    //if some fatal error (assert/resource allocation failure) occured,
    //an exception of type RwExpError will be thrown.
    RwExpError      TraverseScene( const TCHAR *filename, Interface *gi );

    RwExpError      ExportSelectFirstObjectNode(Interface *gi);
    RwBool          ExportSelectNextObjectNode(Interface *gi);

    void            ConvertNode(INode* node, RpClump *clump, RwFrame *frame, RwBool lastChild, BonesContainer & influenceBones);
    Box3            GetHierarchicalBbox(INode* npNode);
    float           ScaleTo_ScaleFactor(INode *node);
    RpSkinAnim *    GenerateSkinAnimFromAnimKeyFrameList(AnimKeyFrameListEntry *keyFrameList, RwInt32 numBones);

    //Animation key sampling - keysample.cpp
    BOOL            AddAnim(INode *node, RpClump *clump, char *name);
    BOOL            AddAnimToFrame(INode *node, RwFrame *frame, char *animName);
    BOOL            AddSkinAnimToFrame(INode *node, RwFrame *frame, char *animName, RwInt32 boneIndex);
    void            AddAnimNodeToAnimInfo(INode* node, ANMInfo *ANMData, RwInt32 keyTypes);
    void            AddNodeAndChildsKeys(INode* node, ANMInfo *ANMData, RwInt32 keyTypes, RwInt32 m_tvStart, RwInt32 m_tvEnd, RwInt32 m_nNumFrames);
    void            AddAnimNodeToAnimInfoIK(INode* node, ANMInfo *ANMData, RwInt32 keyTypes);
    void            DestroyKeyFrameList(AnimKeyFrameListEntry *head);

    /* geometrymangle.cpp */
    //Get vertices, morph targets, polygons, normals, lighting & textured coords out of MAX node,
    //return it as RpGeometry stuffed into a new RpAtomic, atomic is given input frame,
    //and is finally added to clump!
    //vertices & normals are transformed by given transform matrix.
    //Also returns a vertex map - remember to RwFree vertex map!
    // e.g.
    //        if (vertexMap)
    //        {
    //            RwFree(vertexMap);
    //        }
    void            ExtractGeometryFromNode( INode *node, RpClump *clump, RwFrame *inFrame, RpAtomic * & outAtomic, RwInt32 * & outVertexMap, Matrix3 &transform );
    RpGeometry *    CreateGeometryFromMesh(Mesh *mesh, Mtl *nodeMaterial);
    void            SetGeometryTrianglesFromMesh(INode *node, Mesh *mesh, 
                                                    RpGeometry *geometry);

    //transform vertices & normals by transform matrix
    //(we remove scale & translation before doing normals)
    void            SetGeometryKeyFramesFromNode(INode* node, RpGeometry *geometry, int numKeyFrames, RwInt32 *vertexMap, Matrix3 &transform);

    /* Character Studio - characterstudio.cpp */
    void            AddTopLevelBipedPartKeys(INode *nodeHierarchyRoot, ANMInfo *ANMData, RwInt32 m_tvStart, RwInt32 m_tvEnd, RwInt32 m_nNumFrames);
    //void            CalculateCSVertexBoneMap(INode *node, RwInt32 *vertexMap);
public: //will go away soon
    void            ProcessPhysiqueNode(INode *node, INode *rootNode, RpClump *clump);
private:
    int             GetNodeTagValue(INode *node);

    /* Selection set skinning - selsetskin.cpp */
    void            ProcessSelSetSkinNode(INode *node, INode *rootNode, RpClump *clump);
    void            ProcessSelSetSkinNodesInHierarchy(INode *node, INode *rootNode, RpClump *clump );
    void            CalculateSelSetVertexBoneMap(INode *node, TriObject *triObject, RwInt32 *vertexMap);
    RpClump *       CreateBonesClump(RpClump *sourceClump);

    /* Max native skinning functions - maxnativeskin.cpp */
    void            CalculateMaxSkinVertexBoneMap(INode *node, RwInt32 *vertexMap);
    void            ProcessMaxSkinNode(INode *node, RpClump *clump);
    void            ProcessMaxSkinNodesInHierarchy(INode *node, RpClump *clump);

    /* Matrix conversion functions - matrixmangle.cpp */
    Matrix3         GetNodeLTM(INode *node);
    Matrix3         GetObjMatrix(INode *node, RwInt32 frameNum, RwBool clearRoot);

    /* Export Customisation functions */
    RwBool          InitialiseCustomNodeData(INode *node);
    RwBool          SetCustomNodeData(INode *node);
    RwBool          InitialiseCustomFrameData(INode *node, RwFrame *frame);
    RwBool          SetCustomFrameData(INode *node, RwFrame *frame);
    RwBool          CustomiseFileName(TCHAR *filename);
    RwBool          ExportCustomData(char *filename, INode *node);
    RwBool          ExportCustomNode(INode *node, Object *object, RwFrame *frame, RpClump *clump);
    RwBool          CustomIgnoreNodeAndChildren(INode *node);
};

RwBool
GeometryHasColoredMaterials(RpGeometry *geometry);

RwBool
GeometryHasMaterialEffects(RpGeometry *geometry);

RwInt32 *
GenerateVertexMapByMaterial(RpGeometry *geometry);

class DFFClassDesc:public ClassDesc
{
public:    
    int             IsPublic() { return 1; }
    void *          Create(BOOL loading = FALSE) { return new DFFExport; }
    const TCHAR *   ClassName() { return _T("DFF"); }
    SClass_ID       SuperClassID() { return SCENE_EXPORT_CLASS_ID; }
    Class_ID        ClassID();// { return Class_ID(0x26ca511f, 0x62650b34); }
    const TCHAR *   Category() { return _T("DFF Exporter"); }
};

#endif /* DFFEXP_H */
